#include <GConsoleLib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define SEIZAMAX 12
//f[^
struct Star{
	int x, y;		//W
	int magnitude;	//
};
struct Line{
	int startpt, endpt;
};
struct Seiza{
	char *name;		//
	Star *stars;	//̔z
	int starnum;	//̐
	Line *lines;	//̔z
	int linenum;	//̐
};
#define SEIZAMAX 12
Seiza g_seiza[SEIZAMAX];

//֐vg^Cv錾
void DrawSeiza(Seiza*);
void EditSeiza(Seiza*);

int main(){
	//t@Cǂݍ
	FILE *fp;
	if( fopen_s(&fp, "zodiac.txt", "r") != 0 ) {
		printf("t@Cǂݍ݃G[\n");
		return -1;
	}
	char rbuf[256];
	for(int i=0; i<SEIZAMAX; i++){
		if(fgets( rbuf, 256, fp ) == NULL) break;
		//ŏ͐
		int len = strlen(rbuf);
		g_seiza[i].name = (char *)malloc( sizeof(char) * len );
		strncpy_s(g_seiza[i].name, len, rbuf, len-1);
		g_seiza[i].name[len-1] = '\0';//s폜
		//̐
		if(fgets( rbuf, 256, fp ) == NULL) break;
		sscanf_s(rbuf, "%d", &g_seiza[i].starnum);
		//m
		g_seiza[i].stars = 
			(Star *)malloc( sizeof(Star) * g_seiza[i].starnum);
		//f[^ǂݍ
		for(int j=0; j<g_seiza[i].starnum; j++){
			if(fgets( rbuf, 256, fp ) == NULL) break;
			int x, y, m;
			sscanf_s(rbuf, "%d, %d, %d", &x, &y, &m);
			g_seiza[i].stars[j].x = x;
			g_seiza[i].stars[j].y = y;
			g_seiza[i].stars[j].magnitude = m;
		}
		//̐
		if(fgets( rbuf, 256, fp ) == NULL) break;
		sscanf_s(rbuf, "%d", &g_seiza[i].linenum);
		//m
		g_seiza[i].lines = 
			(Line *)malloc( sizeof(Line) * g_seiza[i].starnum);
		//f[^ǂݍ
		for(int j=0; j<g_seiza[i].linenum; j++){
			if(fgets( rbuf, 256, fp ) == NULL) break;
			int sp, ep;
			sscanf_s(rbuf, "%d, %d", &sp, &ep);
			g_seiza[i].lines[j].startpt = sp;
			g_seiza[i].lines[j].endpt = ep;
		}
	}
	fclose(fp);

	gcls();
	gfront();

	int curseiza = 0;	//\EҏW鐯
	char buf[64];
	while(1){
		gcls();
		gimage("C:\\GConsoleǉt@C\\sampleimg\\chap7-1.png", 0, 0);
		DrawSeiza( &g_seiza[curseiza] );
		gcolor(0,0,0);
		glocate(0, 17);
		gprintf("ԍ(0-%d)܂͕ҏW(e)AI(x)", SEIZAMAX-1 );
		ggets(buf, 64);
		char com = buf[0];	//擪o
		switch(com){
			case 'e':
				//ҏW
				EditSeiza( &g_seiza[curseiza] );
				break;
			case 'x':
				//I
				goto PROGRAMQUIT;
				break;
			default:
				//\̐؂ւ
				int num = atoi(buf);
				if( num >=0 && num < SEIZAMAX ){
					curseiza = num;
				}
		}
	}
PROGRAMQUIT:
	//
	for(int i=0; i<SEIZAMAX; i++){
		free( g_seiza[i].name );
		free( g_seiza[i].stars );
		free( g_seiza[i].lines );
	}
}

//̕\
void DrawSeiza(Seiza *sz){
	//Seiza *sz = &g_seiza[seizaid];
	//̕\
	gcolor(255, 255, 0);	//Fɐݒ
	glocate(6, 1);
	gprintf("%s", sz->name );
	//̕\
	for(int i=0; i < sz->starnum; i++){
		gpoint( sz->stars[i].x, sz->stars[i].y, 
			sz->stars[i].magnitude * 2); 
	}
	for(int i=0; i < sz->linenum; i++){
		int sp = sz->lines[i].startpt;
		int ep = sz->lines[i].endpt;
		gline( sz->stars[sp].x, sz->stars[sp].y,
			   sz->stars[ep].x, sz->stars[ep].y );
	}	
	
}

//t@C̕ۑ
void SaveToTextFile(){
	FILE *fp;
	if( fopen_s(&fp, "zodiac.txt", "w") != 0 ) {
		printf("t@C݃G[\n");
		return;
	}
	for(int i=0; i<SEIZAMAX; i++){
		//Ȍo
		fprintf( fp, "%s\n", g_seiza[i].name );
		//̐
		fprintf( fp, "%d\n", g_seiza[i].starnum );
		//f[^o
		for(int j=0; j<g_seiza[i].starnum; j++){
			fprintf( fp, "%d, %d, %d\n", 
				g_seiza[i].stars[j].x, 
				g_seiza[i].stars[j].y, 
				g_seiza[i].stars[j].magnitude );
		}
		//̐
		fprintf( fp, "%d\n", g_seiza[i].linenum );
		//f[^o
		for(int j=0; j<g_seiza[i].linenum; j++){
			fprintf( fp, "%d, %d\n", 
				g_seiza[i].lines[j].startpt, 
				g_seiza[i].lines[j].endpt );
		}
	}
	fclose(fp);
}

//ҏWp̐\
void DrawStarsForEdit(Seiza *sz){
	//ԍ\
	glocate(0,0);
	gcolor(0,0,0);
	for(int i=0; i<20; i++){
		gprintf("%2d ", i);
	}
	//Fĕ\
	int rcol = 64, gcol = 64, bcol = 64;
	for(int i=0; i < sz->starnum; i++){
		gcolor(rcol & 0xFF, gcol & 0xFF, bcol & 0xFF);
		gpoint( sz->stars[i].x, sz->stars[i].y, 
			4); 
		gpoint( i * 30 + 16, 20, 4); 
		rcol += 32;
		if(rcol > 255) gcol += 32;
		if(gcol > 255) bcol += 32;
	}
}

//ҏWp̐\
void DrawLineForEdit(Star *stars, Line *lines, int linenum){
	gcolor(128, 128, 0);
	for(int i=0; i<linenum; i++){
		int sp = lines[i].startpt;
		int ep = lines[i].endpt;
		gline( stars[sp].x, stars[sp].y,
			   stars[ep].x, stars[ep].y );
	}
}

//f[^̕ҏW
void EditSeiza(Seiza *sz){
	//ҏWp̈
	Line *editlines = (Line *)malloc( sizeof(Line) * 40 );
	int editlinenum = 0;
	//̃f[^΃Rs[
	if(sz->linenum > 0){
		memcpy_s(editlines, sizeof(Line) * 40, 
			sz->lines, sizeof(Line) * sz->linenum );
		editlinenum = sz->linenum;
	}
	//R}h
	char com = '\0';
	while(com != 'e'){
		//̕\
		gcls();
		DrawLineForEdit( sz->stars, editlines, editlinenum );
		DrawStarsForEdit(sz);
		glocate(0,15);
		gcolor(0,0,0);
		gprintf("ǉ(a), 폜(d), I(e), fďI(s)");
		com = ggetchar();
		char buf[64];
		int sp=0, ep=0, dl=0;
		switch(com){
			case 'a':
				//̒ǉR}h
				gprintf("\nn_̐ԍ(0-%d)H", sz->starnum - 1);
				ggets(buf, 64);
				sp = atoi(buf);
				gprintf("\nI_̐ԍ(0-%d)H", sz->starnum - 1);
				ggets(buf, 64);
				ep = atoi(buf);
				//mF
				if( sp < 0 || sp >= sz->starnum ||
					ep < 0 || ep >= sz->starnum ) break;
				gcolor(255,0,0);
				gline( sz->stars[sp].x, sz->stars[sp].y,
					   sz->stars[ep].x, sz->stars[ep].y );
				gprintf("\nǉ܂iy/njH");
				com = ggetchar();
				if(com == 'y'){
					if(editlinenum < 40){
						editlines[editlinenum].startpt = sp;
						editlines[editlinenum].endpt = ep;
						editlinenum++;
					}
				}
				break;
			case 'd':
				//̍폜R}h
				gprintf("\n폜ԍ(0-%d)H", editlinenum - 1);
				ggets(buf, 64);
				dl = atoi(buf);
				//mF
				if( dl < 0 || dl >= editlinenum) break;
				sp = editlines[dl].startpt;
				ep = editlines[dl].endpt;
				gcolor(255,0,0);
				gline( sz->stars[sp].x, sz->stars[sp].y,
					   sz->stars[ep].x, sz->stars[ep].y );
				gprintf("\n폜܂iy/njH");
				com = ggetchar();
				if(com == 'y'){
					//Ō̗vfłȂ΋l߂
					if(dl < editlinenum - 1){
						for(int j=dl; j < editlinenum-1; j++){
							editlines[j] = editlines[j+1];
						}
					}
					editlinenum--;
				}
				break;
			case 's':
				//fۑ
				gprintf("\nfĕҏWI܂iy/njH");
				com = ggetchar();
				if(com == 'y'){
					//g_seizaɃf[^𔽉f
					free(sz->lines);	//Â
					sz->linenum = editlinenum;
					sz->lines = (Line *)malloc( sizeof(Line) * editlinenum );
					memcpy_s( sz->lines, sizeof(Line) * editlinenum,
						editlines, sizeof(Line) * editlinenum);
					//t@C̕ۑ
					SaveToTextFile();
					com = 'e';
				}
				break;
		}
	}
	//
	free(editlines);
}